/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.util;

import com.ibm.hwmca.base.rsf.util.FtsException;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public final class FtService
implements FcsService {
    private static final String TRACE_MASKT = "XRSFFTST";
    private static final String TRACE_MASKF = "XRSFFTSF";
    private static final String TRACE_MASKD = "XRSFFTSD";
    public static FcsServiceId ftServiceId = new FcsServiceId("FtService", 1.0);
    private static FcsServer fcsServer = FcsServer.getFcsServer();
    private static Object renameLock = new Object();
    private static File tempPath;
    private static FtService fts;

    public static FtService getFtService() {
        return fts;
    }

    private FtService() {
        fcsServer.addLocalService(ftServiceId, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean get(MachineId target, String localFilename, String remoteFilename) throws FtsException {
        Trace.trace(TRACE_MASKT, "-> FtService::get()");
        File localFile = new File(localFilename);
        if (localFile.exists()) {
            if (!localFile.isFile()) throw new FtsException("Invalid " + localFilename + " is either not a file or not writeable");
            if (!localFile.canWrite()) {
                throw new FtsException("Invalid " + localFilename + " is either not a file or not writeable");
            }
        } else {
            File parent = localFile.getParentFile();
            if (parent == null) throw new FtsException("Path for " + localFilename + " does not exist or does not have write access");
            if (!parent.isDirectory()) throw new FtsException("Path for " + localFilename + " does not exist or does not have write access");
            if (!parent.canWrite()) {
                throw new FtsException("Path for " + localFilename + " does not exist or does not have write access");
            }
        }
        boolean result = false;
        String targetInfo = this.machineInfo(target);
        Trace.trace(TRACE_MASKD, "-> FtService.get: targetInfo=" + targetInfo);
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            try {
                Trace.trace(TRACE_MASKD, "FtService.get: connect to FtService");
                FcsConnection connection = FcsConnection.connect(target, ftServiceId);
                Trace.trace(TRACE_MASKD, "FtService.get: connected to FtService");
                Socket socket = connection.getSocket();
                Trace.trace(TRACE_MASKD, "FtService.get: got socket");
                oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream(), 1024));
                Trace.trace(TRACE_MASKD, "FtService.get: got output stream");
                oos.flush();
                Trace.trace(TRACE_MASKD, "FtService.get: flushed output stream");
                ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream(), 1024));
                Trace.trace(TRACE_MASKD, "FtService.get: about to write to FtService");
                oos.writeObject("get " + remoteFilename);
                oos.flush();
                Trace.trace(TRACE_MASKD, "FtService.get: wrote to FtService");
                String handshake = (String)ois.readObject();
                Trace.trace(TRACE_MASKD, "FtService.get: read from FtService");
                if (!handshake.equalsIgnoreCase("OK")) throw new FtsException("Error response from server when 'get' requested = " + handshake);
                result = this.receiveFile(ois, localFile);
                Object var14_14 = null;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "FtService.get Exception: " + e.getMessage());
                throw new FtsException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois == null) throw throwable;
                ois.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (oos != null) {
            oos.close();
        }
        if (ois != null) {
            ois.close();
        }
        Trace.trace(TRACE_MASKT, "<- FtService::get()");
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean put(MachineId target, String localFilename, String remoteFilename) throws FtsException {
        Trace.trace(TRACE_MASKT, "-> FtService::put()");
        File localFile = new File(localFilename);
        if (!localFile.isFile()) throw new FtsException("File " + localFilename + " does not exist or does not have read access");
        if (!localFile.canRead()) {
            throw new FtsException("File " + localFilename + " does not exist or does not have read access");
        }
        boolean result = false;
        String targetInfo = this.machineInfo(target);
        Trace.trace(TRACE_MASKD, "-> FtService.get: targetInfo=" + targetInfo);
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            try {
                FcsConnection connection = FcsConnection.connect(target, ftServiceId);
                Socket socket = connection.getSocket();
                oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream(), 1024));
                oos.flush();
                ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream(), 1024));
                oos.writeObject("put " + remoteFilename);
                oos.flush();
                String handshake = (String)ois.readObject();
                if (!handshake.equalsIgnoreCase("OK")) throw new FtsException("Error response from server when 'put' requested = " + handshake);
                result = this.sendFile(oos, localFile);
                Object var13_13 = null;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "FtService.get Exception: " + e.getMessage());
                throw new FtsException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois == null) throw throwable;
                ois.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (oos != null) {
            oos.close();
        }
        if (ois != null) {
            ois.close();
        }
        Trace.trace(TRACE_MASKT, "<- FtService::put()");
        return result;
    }

    private boolean sendFile(ObjectOutputStream oos, File file) throws FtsException {
        BufferedInputStream fis;
        File tempFile;
        Trace.trace(TRACE_MASKT, "-> FtService::sendFile()");
        try {
            tempFile = File.createTempFile("iqy", ".tmp", tempPath);
            FileUtilities.copy(file, tempFile);
        }
        catch (Exception e) {
            throw new FtsException("FtService.sendFile: unable to create temp file: " + e.getMessage());
        }
        long length = tempFile.length();
        try {
            fis = new BufferedInputStream(new FileInputStream(tempFile), 1024);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "FtService.sendFile: unable to create File input stream");
            try {
                oos.writeLong(0L);
                oos.flush();
            }
            catch (IOException ioe) {
                tempFile.delete();
                throw new FtsException("FtService.sendFile: unable to send filelength (=0) to target: " + ioe.getMessage());
            }
            return false;
        }
        byte[] buffer = new byte[1024];
        try {
            int i;
            oos.writeLong(length);
            oos.flush();
            int total = 0;
            while ((i = fis.read(buffer, 0, buffer.length)) > 0) {
                oos.write(buffer, 0, i);
                total += i;
            }
            Trace.trace(TRACE_MASKF, "Promised " + length + " bytes. Sent " + total + " bytes");
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "FtService.sendFile Exception: " + e.getMessage());
            tempFile.delete();
            throw new FtsException(e.getMessage());
        }
        Trace.trace(TRACE_MASKT, "<- FtService::sendFile()");
        tempFile.delete();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean receiveFile(ObjectInputStream ois, File file) throws FtsException {
        BufferedOutputStream fos;
        String filename = file.getAbsolutePath();
        Trace.trace(TRACE_MASKT, "-> FtService::receiveFile() " + filename);
        File temp = null;
        try {
            temp = File.createTempFile("rsf", ".tmp", file.getParentFile());
            fos = new BufferedOutputStream(new FileOutputStream(temp), 1024);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "FtService.receiveFile: unable to create File output stream");
            return false;
        }
        try {
            long length = ois.readLong();
            Trace.trace(TRACE_MASKF, "FtService.receiveFile: about to copy " + length + "bytes to " + temp.getAbsolutePath());
            byte[] buffer = new byte[1024];
            int b = 0;
            int tot = 0;
            while (b != -1 && (long)tot < length) {
                b = ois.read(buffer, 0, buffer.length);
                fos.write(buffer, 0, b);
                tot += b;
            }
            fos.flush();
            fos.close();
            Trace.trace(TRACE_MASKD, "FtService.receivedFile: file " + temp.getAbsolutePath() + " =" + temp.length());
            Object object = renameLock;
            synchronized (object) {
                temp.renameTo(file);
                Trace.trace(TRACE_MASKF, "FtService.receiveFile: length of file =" + temp.length());
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "FtService.receiveFile Exception: " + e.getMessage());
            throw new FtsException(e.getMessage());
        }
        Trace.trace(TRACE_MASKT, "<- FtService::receiveFile()");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processConnection(FcsConnection connection) {
        block40: {
            block37: {
                block39: {
                    block38: {
                        block36: {
                            block35: {
                                block34: {
                                    sender = connection.getMachineId();
                                    senderInfo = this.machineInfo(sender);
                                    Trace.trace("XRSFFTST", "-> FtService.processConnection() " + senderInfo);
                                    query = null;
                                    parms = null;
                                    response = null;
                                    ois = null;
                                    oos = null;
                                    try {
                                        try {
                                            socket = connection.getSocket();
                                            Trace.trace("XRSFFTSD", "FtService.process connection: got socket");
                                            oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream(), 1024));
                                            Trace.trace("XRSFFTSD", "FtService.process connection: got output stream");
                                            oos.flush();
                                            Trace.trace("XRSFFTSD", "FtService.process connection: flushed output stream");
                                            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream(), 1024));
                                            Trace.trace("XRSFFTSD", "FtService.process connection: reading object");
                                            request = ((String)ois.readObject()).trim();
                                            Trace.trace("XRSFFTSD", "FtService.process connection: read:" + request);
                                            commandSeparator = request.indexOf(" ");
                                            if (commandSeparator == -1) {
                                                query = request;
                                            } else {
                                                query = request.substring(0, commandSeparator);
                                                if (commandSeparator + 1 < request.length()) {
                                                    parms = request.substring(commandSeparator + 1);
                                                }
                                            }
                                            if (!query.equalsIgnoreCase("get") && !query.equalsIgnoreCase("put")) {
                                                Trace.trace("XRSFFTSF", "FtService.process command: invalid command '" + query + "' received");
                                                oos.writeObject("Invalid command: " + query);
                                                oos.flush();
                                                var15_13 = null;
                                                break block34;
                                            }
                                            if (parms == null) {
                                                Trace.trace("XRSFFTSF", "FtService.processCommand: no filename specified");
                                                oos.writeObject("No filename specified");
                                                oos.flush();
                                                break block35;
                                            }
                                            localFile = new File(parms);
                                            if (query.equalsIgnoreCase("get")) {
                                                if (!localFile.isFile() || !localFile.canRead()) {
                                                    Trace.trace("XRSFFTSF", "FtService.processCommand: File " + parms + " does not exist or cannot be read");
                                                    oos.writeObject("File name '" + parms + "' does not exist or cannot be read");
                                                    oos.flush();
                                                    break block36;
                                                }
                                                oos.writeObject("OK");
                                                oos.flush();
                                                this.sendFile(oos, localFile);
                                                break block37;
                                            }
                                            if (localFile.exists()) {
                                                if (!localFile.isFile() || !localFile.canWrite()) {
                                                    Trace.trace("XRSFFTSF", "FtService.processCommand: Filename " + parms + " is either not a file or not writeable");
                                                    oos.writeObject("Filename " + parms + " is either not a file or not writeable");
                                                    oos.flush();
                                                    break block38;
                                                }
                                            } else {
                                                parent = localFile.getParentFile();
                                                if (parent == null || !parent.isDirectory() || !parent.canWrite()) {
                                                    Trace.trace("XRSFFTSF", "FtService.processCommand: Path for " + parms + " does not exist or does not have write access");
                                                    oos.writeObject("Path for " + parms + " does not exist or does not have write access");
                                                    oos.flush();
                                                    break block39;
                                                }
                                            }
                                            oos.writeObject("OK");
                                            oos.flush();
                                            this.receiveFile(ois, localFile);
                                            break block37;
                                        }
                                        catch (Exception e) {
                                            Trace.trace("XRSFFTSF", "FtService.processConnection Exception");
                                            Trace.trace("XRSFFTSF", e);
                                            var15_19 = null;
                                            try {
                                                if (oos != null) {
                                                    oos.close();
                                                }
                                                if (ois != null) {
                                                    ois.close();
                                                }
                                                break block40;
                                            }
                                            catch (IOException ioe) {}
                                            break block40;
                                        }
                                    }
                                    catch (Throwable var14_31) {
                                        var15_20 = null;
                                        ** try [egrp 2[TRYBLOCK] [14 : 720->743)] { 
lbl92:
                                        // 1 sources

                                        if (oos != null) {
                                            oos.close();
                                        }
                                        if (ois == null) throw var14_31;
                                        ois.close();
                                        throw var14_31;
lbl97:
                                        // 1 sources

                                        catch (IOException ioe) {
                                            // empty catch block
                                        }
                                        throw var14_31;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [14 : 720->743)] { 
lbl102:
                                // 1 sources

                                if (oos != null) {
                                    oos.close();
                                }
                                if (ois == null) return;
                                ois.close();
                                return;
lbl107:
                                // 1 sources

                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                return;
                            }
                            var15_14 = null;
                            ** try [egrp 2[TRYBLOCK] [14 : 720->743)] { 
lbl113:
                            // 1 sources

                            if (oos != null) {
                                oos.close();
                            }
                            if (ois == null) return;
                            ois.close();
                            return;
lbl118:
                            // 1 sources

                            catch (IOException ioe) {
                                // empty catch block
                            }
                            return;
                        }
                        var15_15 = null;
                        ** try [egrp 2[TRYBLOCK] [14 : 720->743)] { 
lbl124:
                        // 1 sources

                        if (oos != null) {
                            oos.close();
                        }
                        if (ois == null) return;
                        ois.close();
                        return;
lbl129:
                        // 1 sources

                        catch (IOException ioe) {
                            // empty catch block
                        }
                        return;
                    }
                    var15_16 = null;
                    ** try [egrp 2[TRYBLOCK] [14 : 720->743)] { 
lbl135:
                    // 1 sources

                    if (oos != null) {
                        oos.close();
                    }
                    if (ois == null) return;
                    ois.close();
                    return;
lbl140:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
                var15_17 = null;
                ** try [egrp 2[TRYBLOCK] [14 : 720->743)] { 
lbl146:
                // 1 sources

                if (oos != null) {
                    oos.close();
                }
                if (ois == null) return;
                ois.close();
                return;
lbl151:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            var15_18 = null;
            try {}
            catch (IOException ioe) {}
            if (oos != null) {
                oos.close();
            }
            if (ois != null) {
                ois.close();
            }
        }
        Trace.trace("XRSFFTST", "<- FtService.processConnection()");
    }

    private String machineInfo(MachineId machine) {
        InetAddress[] nicAddresses = machine.getNicAddresses();
        return machine.getName() + "(" + nicAddresses[0] + ")";
    }

    static {
        fts = new FtService();
        try {
            tempPath = new File(BaseFileControl.getFilePath("tmp"));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "FtService: static block - Unable to get temp file path");
        }
    }
}

